/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Domain;
import com.filenet.wcm.api.Domains;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.ValueObject;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMContents;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMPropertyDescription;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMContents;
import filenet.vw.idm.trident.VWIDMTridentAttachment;
import filenet.vw.idm.trident.VWIDMTridentCustomObject;
import filenet.vw.idm.trident.VWIDMTridentDocClass;
import filenet.vw.idm.trident.VWIDMTridentDocument;
import filenet.vw.idm.trident.VWIDMTridentFolder;
import filenet.vw.idm.trident.VWIDMTridentLibrary;
import filenet.vw.idm.trident.VWIDMTridentStoredSearch;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

abstract class VWIDMTridentItem
implements Serializable,
IVWIDMItem {
    protected static Logger logger = Logger.getLogger("filenet.vw.idm");
    WcmDlgItem m_dlgItem = null;
    ReadableMetadataObject m_wcmObject = null;
    String m_id = null;
    String m_label = null;
    String m_labelPropName = "Name";
    int m_libType = 3;
    VWIDMTridentLibrary m_lib = null;
    IVWIDMDocClass m_classDesc = null;
    IVWIDMPropertyDescription[] m_propDescs = null;
    private static final String m_className = "VWIDMTridentItem";
    protected VWIDMTridentItem[] m_contents = null;
    protected VWIDMContents m_contentsObj = null;
    protected boolean m_dirty = false;
    protected Hashtable m_props = new Hashtable(5);
    protected IVWIDMDocClass m_classDescription = null;

    VWIDMTridentItem() {
    }

    public static IVWIDMItem fromWcmDlgItem(WcmDlgItem dlgItem) {
        String m_method = "fromWcmDlgItem";
        try {
            ReadableMetadataObject obj = dlgItem.getWcmObject();
            String libraryId = obj.getObjectStoreId();
            if (obj instanceof ObjectStore) {
                return new VWIDMTridentLibrary((ObjectStore)obj, dlgItem);
            }
            if (obj instanceof Folder) {
                Folder folder = (Folder)obj;
                return new VWIDMTridentFolder(folder, VWIDMTridentItem.getLibrary(libraryId), dlgItem);
            }
            if (obj instanceof Document) {
                Document doc = (Document)obj;
                return new VWIDMTridentDocument(doc, VWIDMTridentItem.getLibrary(libraryId), dlgItem);
            }
            if (obj instanceof StoredSearch) {
                StoredSearch search = (StoredSearch)obj;
                return new VWIDMTridentStoredSearch(search, VWIDMTridentItem.getLibrary(libraryId), dlgItem);
            }
            if (obj instanceof CustomObject) {
                CustomObject custObj = (CustomObject)obj;
                return new VWIDMTridentCustomObject(custObj, VWIDMTridentItem.getLibrary(libraryId), dlgItem);
            }
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
        }
        return null;
    }

    public WcmDlgItem getWcmDlgItem() {
        return this.m_dlgItem;
    }

    protected ReadableMetadataObject getBrightspireObject() {
        return this.m_wcmObject;
    }

    protected IVWIDMPropertyDescription getPropDescription(String name) throws VWException {
        String m_method = "getPropDescription:" + name;
        try {
            if (this.m_propDescs == null) {
                this.getClassAndPropertyDescriptions();
            }
            if (this.m_propDescs != null) {
                for (int i = 0; i < this.m_propDescs.length; ++i) {
                    if (!this.m_propDescs[i].getName().equals(name)) continue;
                    return this.m_propDescs[i];
                }
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
        throw new VWException("idm.toolkit.trident.VWIDMTridentItem.getPropertyDescription", "Cannot find property description for {0}.", name);
    }

    protected void getClassAndPropertyDescriptions() throws Exception {
        if (this.m_classDesc == null || this.m_propDescs == null) {
            this.m_classDesc = VWIDMTridentDocClass.fromClassDescription((ClassDescription)this.getProp("ClassDescription"), this.m_lib);
            this.m_propDescs = this.m_classDesc.getPropertyDescriptions();
        }
    }

    protected static Property getCEPropertyWithVal(String key, Object val) {
        if (val == null) {
            return null;
        }
        String m_method = "geCEPropertyWithVal:" + key;
        logger.entering(m_className, m_method);
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Value(toString) = " + val.toString());
        }
        Property prop = ObjectFactory.getProperty((String)key);
        if (val instanceof Boolean) {
            prop.setValue((Boolean)val);
        } else if (val instanceof Date) {
            prop.setValue((Date)val);
        } else if (val instanceof GregorianCalendar) {
            prop.setValue(((GregorianCalendar)val).getTime());
        } else if (val instanceof Double) {
            prop.setValue((Double)val);
        } else if (val instanceof Integer) {
            prop.setValue((Integer)val);
        } else if (val instanceof String) {
            prop.setValue((String)val);
        } else if (val instanceof ReadableMetadataObject) {
            prop.setValue((ValueObject)((ReadableMetadataObject)val));
        } else if (val instanceof Values) {
            prop.setValue((ValueObject)((Values)val));
        } else if (val.getClass().isArray()) {
            Values values = ObjectFactory.getValues();
            if (values == null) {
                return prop;
            }
            if (val instanceof Boolean[]) {
                Boolean[] vals = (Boolean[])val;
                for (int i = 0; i < vals.length; ++i) {
                    Value v = ObjectFactory.getValue();
                    v.setValue(vals[i]);
                    values.add((Object)v);
                }
            } else if (val instanceof Date[] || val instanceof GregorianCalendar[]) {
                Date[] vals = null;
                if (val instanceof Date[]) {
                    vals = (Date[])val;
                } else if (val instanceof GregorianCalendar[]) {
                    GregorianCalendar[] vCal = (GregorianCalendar[])val;
                    vals = new Date[vCal.length];
                    for (int i = 0; i < vCal.length; ++i) {
                        vals[i] = vCal[i].getTime();
                    }
                }
                if (vals != null) {
                    for (int i = 0; i < vals.length; ++i) {
                        Value v = ObjectFactory.getValue();
                        v.setValue(vals[i]);
                        values.add((Object)v);
                    }
                }
            } else if (val instanceof Double[]) {
                Double[] vals = (Double[])val;
                for (int i = 0; i < vals.length; ++i) {
                    Value v = ObjectFactory.getValue();
                    v.setValue(vals[i]);
                    values.add((Object)v);
                }
            } else if (val instanceof Integer[]) {
                Integer[] vals = (Integer[])val;
                for (int i = 0; i < vals.length; ++i) {
                    Value v = ObjectFactory.getValue();
                    v.setValue(vals[i]);
                    values.add((Object)v);
                }
            } else if (val instanceof ReadableMetadataObject[]) {
                ReadableMetadataObject[] vals = (ReadableMetadataObject[])val;
                for (int i = 0; i < vals.length; ++i) {
                    Value v = ObjectFactory.getValue();
                    v.setValue((ValueObject)vals[i]);
                    values.add((Object)v);
                }
            } else if (val instanceof String[]) {
                String[] vals = (String[])val;
                for (int i = 0; i < vals.length; ++i) {
                    Value v = ObjectFactory.getValue();
                    v.setValue(vals[i]);
                    values.add((Object)v);
                }
            }
            prop.setValue((ValueObject)values);
        }
        logger.exiting(m_className, m_method);
        return prop;
    }

    protected Properties getSaveProperties() throws VWException {
        String m_method = "getSaveProperties:" + this.getId();
        try {
            int nProps = this.m_props.size();
            if (nProps == 0) {
                return null;
            }
            String[] keys = this.m_props.keySet().toArray(new String[0]);
            Properties props = ObjectFactory.getProperties();
            for (String key : keys) {
                Object val = this.m_props.get(key);
                props.add((Object)VWIDMTridentItem.getCEPropertyWithVal(key, val));
            }
            return props;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.toolkit.trident.VWIDMTridentItem.saveProperties", "{0}", e.getMessage());
        }
    }

    protected static Object mapGetPropertyValue(Object inVal, String propName, Property prop) {
        return VWIDMTridentItem.mapGetPropertyValue(inVal, propName, prop.getType());
    }

    protected static Object mapGetPropertyValue(Object inVal, String propName, int propType) {
        if (inVal == null) {
            return inVal;
        }
        String m_method = "mapGetPropertyValue:" + propName;
        if (inVal instanceof List) {
            List vals = (List)inVal;
            int nValues = vals.size();
            inVal = null;
            logger.fine(m_className, m_method, "is multivalue");
            switch (propType) {
                case 8: {
                    String[] arrayVal = new String[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = val.getStringValue();
                    }
                    return arrayVal;
                }
                case 2: {
                    Boolean[] arrayVal = new Boolean[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = (Boolean)val.getValue();
                    }
                    return arrayVal;
                }
                case 3: {
                    GregorianCalendar[] arrayVal = new GregorianCalendar[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = new GregorianCalendar();
                        arrayVal[i].setTime(val.getDateValue());
                    }
                    return arrayVal;
                }
                case 4: {
                    Double[] arrayVal = new Double[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = (Double)val.getValue();
                    }
                    return arrayVal;
                }
                case 6: {
                    Integer[] arrayVal = new Integer[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = (Integer)val.getValue();
                    }
                    return arrayVal;
                }
                case 7: {
                    Object[] arrayVal = new Object[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = val.getValue();
                    }
                    return arrayVal;
                }
                case 5: {
                    String[] arrayVal = new String[nValues];
                    for (int i = 0; i < nValues; ++i) {
                        Value val = (Value)vals.get(i);
                        if (val == null) continue;
                        arrayVal[i] = val.getValue().toString();
                    }
                    return arrayVal;
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Can't figure out what to do with the type!");
            }
        } else if (inVal instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime((Date)inVal);
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss zzz");
            String dateText = df.format((Date)inVal);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, propName + " is a DATE=" + dateText);
            }
            return cal;
        }
        return inVal;
    }

    public static VWIDMTridentItem getItem(String path) throws VWException {
        int type;
        String m_method = "getItem:" + path;
        logger.entering(m_className, m_method);
        StringTokenizer stmp = new StringTokenizer(path, ":");
        String token = null;
        String library = null;
        String id = null;
        String version = null;
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                type = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("idm.trident.VWIDMTridentItem.getItem2a", "{0}: Invalid type.", path);
            }
            if (type < 0 || type > 6) {
                throw new VWException("idm.trident.VWIDMTridentItem.getItem2a", "{0}: Invalid type.", path);
            }
        } else {
            throw new VWException("idm.trident.VWIDMTridentItem.getItem2c", "{0}: Invalid IDM Item name.", path);
        }
        if (stmp.hasMoreTokens()) {
            int libType;
            token = stmp.nextToken();
            try {
                libType = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("idm.trident.VWIDMTridentItem.getItem2b", "{0}: Invalid library type.", path);
            }
            if (libType < 0 || libType > 3) {
                throw new VWException("idm.trident.VWIDMTridentItem.getItem2a", "{0}: Invalid library type.", path);
            }
        } else {
            throw new VWException("idm.trident.VWIDMTridentItem.getItem2d", "{0}: Missing library type.", path);
        }
        if (!stmp.hasMoreTokens()) {
            throw new VWException("idm.trident.VWIDMTridentItem.getItem2", "{0}: Missing library name.", path);
        }
        library = stmp.nextToken();
        if (type == 1) {
            return VWIDMTridentItem.getLibrary(library);
        }
        if (stmp.hasMoreTokens()) {
            id = stmp.nextToken();
            if (stmp.hasMoreTokens()) {
                version = stmp.nextToken();
            }
        } else {
            throw new VWException("idm.trident.VWIDMTridentItem.getItem2", "{0}: Missing id.", path);
        }
        return VWIDMTridentItem.getItem(type, library, id, version);
    }

    public static VWIDMTridentItem getItem(int type, String library, String id, String version) throws VWException {
        logger.entering(m_className, "getItem:" + Integer.toString(type) + ",lib=" + library + ",id=" + (id == null ? "NULL" : id) + ",version=" + (version == null ? "NULL" : version));
        switch (type) {
            case 1: {
                return VWIDMTridentItem.getLibrary(library);
            }
            case 2: {
                return (VWIDMTridentItem)((Object)VWIDMTridentItem.getLibrary(library).getFolder(id));
            }
            case 3: {
                return (VWIDMTridentItem)((Object)VWIDMTridentItem.getLibrary(library).getDocument(id, version));
            }
            case 4: {
                return (VWIDMTridentItem)VWIDMTridentItem.getLibrary(library).getStoredSearch(id, version);
            }
            case 6: {
                return (VWIDMTridentItem)VWIDMTridentItem.getLibrary(library).getCustomObject(id);
            }
        }
        return null;
    }

    private static ObjectStores getObjectStores(Session ses) {
        if (ses == null) {
            return null;
        }
        EntireNetwork nbh = ObjectFactory.getEntireNetwork((Session)ses);
        Domains domains = nbh.getDomains();
        if (domains == null) {
            return null;
        }
        Domain domain = (Domain)domains.get(0);
        return domain.getObjectStores();
    }

    protected static VWIDMTridentLibrary getLibrary(String libId) throws VWException {
        String m_method = "getLibrary:" + libId;
        logger.entering(m_className, m_method);
        IVWIDMFactoryProperties props = VWIDMBaseFactory.instance().getProperties();
        Session ses = (Session)props.getProperty("Session");
        ObjectStores libs = VWIDMTridentItem.getObjectStores(ses);
        if (libs != null) {
            String id = null;
            String name = null;
            String symbolicName = null;
            int nLibs = libs.size();
            for (int i = 0; i < nLibs; ++i) {
                ObjectStore lib = (ObjectStore)libs.get(i);
                id = lib.getId();
                name = lib.getName();
                try {
                    symbolicName = lib.getPropertyStringValue("SymbolicName");
                }
                catch (PropertyNotFoundException pnfe) {
                    // empty catch block
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "getLibraries lib=" + id + ",name=" + name + ",symbolicname=" + name);
                }
                if (!libId.equalsIgnoreCase(id) && !libId.equalsIgnoreCase(name) && !libId.equalsIgnoreCase(symbolicName)) continue;
                return new VWIDMTridentLibrary(lib);
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Cannot get library! " + libId);
        }
        throw new VWException("idm.trident.IDMItem.getLibrary2", "Failed to get Library {0}.  Library does not exist.", libId);
    }

    public static IVWIDMItem getItemFromVWAttachment(VWAttachment vwAtt) throws VWException {
        String m_method = "getItemFromVWAttachment";
        if (vwAtt == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Invalid parameter");
            }
            throw new VWException("idm.trident.VWIDMTridentItem.getItemFromVWAttachment", "Invalid parameter");
        }
        String library = vwAtt.getLibraryName();
        String id = vwAtt.getId();
        String version = vwAtt.getVersion();
        switch (vwAtt.getType()) {
            case 1: {
                return VWIDMTridentItem.getLibrary(id);
            }
            case 2: {
                return (VWIDMTridentItem)((Object)VWIDMTridentItem.getLibrary(library).getFolder(id));
            }
            case 3: {
                return (VWIDMTridentItem)((Object)VWIDMTridentItem.getLibrary(library).getDocument(id, version));
            }
            case 4: {
                return (VWIDMTridentItem)VWIDMTridentItem.getLibrary(library).getStoredSearch(id, version);
            }
            case 6: {
                return (VWIDMTridentItem)VWIDMTridentItem.getLibrary(library).getCustomObject(id);
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Unsupported type:" + Integer.toString(vwAtt.getType()));
        }
        throw new VWException("idm.trident.VWIDMTridentItem.getItemFromVWAttachment2", "Unsupported type");
    }

    public String getId() {
        if (this.m_wcmObject != null) {
            this.m_id = this.m_wcmObject.getId();
        }
        return this.m_id;
    }

    public String getLabel() {
        if (this.m_label == null) {
            try {
                this.m_label = (String)this.getProp(this.m_labelPropName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_label;
    }

    public int getLibraryType() {
        return this.m_libType;
    }

    public IVWIDMAttachment getAttachment() throws VWException {
        return VWIDMTridentAttachment.fromIVWIDMItem(this);
    }

    public VWAttachment getVWAttachment() throws VWException {
        String m_method = "getVWAttachment";
        VWAttachment ret = new VWAttachment();
        ret.setType(this.getType());
        ret.setLibraryType(this.getLibraryType());
        ret.setLibraryName(this.getLibraryLabel());
        ret.setId(this.m_id);
        ret.setAttachmentName(this.getLabel());
        logger.fine(m_className, m_method, "returns " + ret.toString());
        return ret;
    }

    public void refresh() throws VWException {
        if (this.m_wcmObject != null) {
            this.m_wcmObject.refresh();
        }
        if (this.m_dlgItem != null) {
            try {
                this.m_dlgItem.getParent().clearContents();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_label = null;
    }

    public void setProp(String propName, Object propVal) throws VWException {
        if (propName == null || propVal == null) {
            throw new VWException("idm.trident.VWIDMTridentItem.setProp", "Invalid property name or value");
        }
        this.m_props.put(propName, propVal);
    }

    protected static IVWIDMLibrary[] getLibraries() throws VWException {
        IVWIDMFactoryProperties props = VWIDMBaseFactory.instance().getProperties();
        Session ses = (Session)props.getProperty("Session");
        ObjectStores libs = VWIDMTridentItem.getObjectStores(ses);
        IVWIDMLibrary[] res = null;
        if (libs != null) {
            int nLibs = libs.size();
            res = new IVWIDMLibrary[nLibs];
            for (int i = 0; i < nLibs; ++i) {
                res[i] = new VWIDMTridentLibrary((ObjectStore)libs.get(i));
            }
            return res;
        }
        return null;
    }

    public boolean userCanChangePermissions(String userName) throws VWException {
        return false;
    }

    public IVWIDMContents listContents(int bufferSize) throws VWException {
        throw new VWException("idm.trident.IDMItem.implBySubClass", "To be implemented by subclass");
    }

    protected void clearContents() {
        try {
            if (this.m_contents != null) {
                for (int i = 0; i < this.m_contents.length; ++i) {
                    this.m_contents[i].clearContents();
                    this.m_contents[i].cleanup();
                    this.m_contents[i] = null;
                }
            }
            this.m_contents = null;
            if (this.m_contentsObj != null) {
                this.m_contentsObj.release();
            }
            this.m_contentsObj = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void cleanup() {
    }

    protected abstract void initContents() throws VWException;

    public IVWIDMItem[] list(boolean dirOnly) throws VWException {
        return this.list();
    }

    public IVWIDMItem[] list() throws VWException {
        try {
            if (this.m_dirty) {
                this.clearContents();
            }
            if (this.m_contents == null) {
                this.initContents();
            }
            this.m_dirty = false;
            return this.m_contents;
        }
        catch (Exception e) {
            throw new VWException("idm.trident.IDMItem.list", "Exception: {0}", e.getMessage());
        }
    }

    public IVWIDMDocClass getClassDescription() throws VWException {
        String m_method = "getClassDescription";
        if (this.m_classDescription == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "calling getProp for ClassDescription");
            }
            ClassDescription classDesc = (ClassDescription)this.getProp("ClassDescription");
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Got classDesc!");
            }
            this.m_classDescription = new VWIDMTridentDocClass(classDesc, this.m_lib);
        }
        if (this.m_classDescription == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "No docclass for " + this.getId());
            }
            throw new VWException("idm.trident.IDMTridentItem.getClassDescription", "Cannot retrieve class description for {0}.", this.getId());
        }
        return this.m_classDescription;
    }

    public IVWIDMPropertyDescription[] getPropertyDescriptions() throws VWException {
        return this.getClassDescription().getPropertyDescriptions();
    }

    public String getName() {
        return this.getLabel();
    }
}

